import gc
import streamlit as st
import sys
import os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

# Home Page Configs
st.set_page_config(
    page_title="BimiKa",
    page_icon="🤖🤖",
    layout="centered",
    initial_sidebar_state="collapsed",
    # menu_items={"About": "Analysis Dashboard Made by ..."},
)

# font-size: 16px;
# font-weight: 500;
# color: #091747;
st.markdown("""
<style>
    @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@100&display=swap'); 
    html, body, [class*="css"] {
        font-family: 'Roboto', sans-serif; 
        direction: rtl;
        text-align: center;
    }
    button, input, optgroup, select, textarea {
        direction: rtl;
        text-align: center;
    }
    .stButton button {
        direction: rtl;
    }
    header {
        direction: rtl;
    }
    .main {
        direction: rtl;
    }
    .stPageLink {
        text-align: center !important;
    }
    .stPageLink a {
        text-align: center !important;
        justify-content: center !important;
    }
</style>
""", unsafe_allow_html=True)

st.logo(image="static/images/bimika.jpg", size="large", link="http://localhost:8501")
st.title("سامانه پاسخگویی هوشمند بیمیکا")

_, img_col2, _ = st.columns([1, 1, 1])
img_col2.image(image="static/images/bimika.jpg", use_container_width=True)

mq_page = st.Page(
    page="pages/BimiKa AI Agent.py", title="BimiKa AIAgent", icon="🤖"
)

_, page_link_col2, _ = st.columns([1, 1, 1])
page_link_col2.page_link(page="pages/BimiKa AI Agent.py", label="شروع", icon="🤖", help="برای شروع کلیک کنید", use_container_width=True)

gc.collect()
